	subroutine INIT(iout, idbg, Ne, Nn, Nb, Nm, Np, Nd, Ns, NnNd, dt, &
			theta, theta1, BCe, BCi, BCn, BCvalue, BCtype, ie, x, nmat, &
			C, T, Cold, Told, M1, par, In, Iyn, Kappa, tc, &
			vA, vL, vB, vQc1, vQd1, vF1, vQc2, vQd2, vF2, vY, vZ, &
			rA, rL, rB, rQc1, rQd1, rF1, rQc2, rQd2, rF2, rY, rZ, &
			cA, cL, cB, cQc1, cQd1, cF1, cQc2, cQd2, cF2, cY, cZ, &
			lastA, lastL, lastB, lastY, lastZ, lastQc1, lastQd1, lastF1, &
			lastQc2, lastQd2, lastF2, V, Vm, Ao, gm0, gm1, m1s, &
			phi, phio, &
			Nr, order, Rr)		! ### new parameters ###
! initialize

	implicit none
	integer iout, idbg
	integer Ne, Nn, Nb, Nm, Np, Nd, Ns, Npsi, NnNd	! array parameters
	integer lastA, lastL, lastB, lastQc1, lastQd1, lastF1, lastQc2, lastQd2, lastF2
	integer lastY, lastZ
	real*8 Kappa, tc
	real*8 dt
	real*8 theta, theta1
	integer BCe(Nb,3), BCi(Nb)		! BC element and local element face numbers
	integer rA (Nn+1), rL (Nn+1), rB(Nn+1)	! global  arrays (compact rows)
	integer cA (NnNd), cL (NnNd), cB(NnNd)	! global  arrays (compact columns)
	integer rY (Nn+1), cY (NnNd)		! global  arrays
	integer rZ (Nn+1), cZ (NnNd)		! global  arrays
	integer rQc1(Nn+1), rQd1(Nn+1), rF1(Nn+1)	! global  arrays (compact rows)
	integer rQc2(Nn+1), rQd2(Nn+1), rF2(Nn+1)	! global  arrays (compact rows)
	integer cQc1(NnNd), cQd1(NnNd), cF1(NnNd)	! global  arrays (compact columns)
	integer cQc2(NnNd), cQd2(NnNd), cF2(NnNd)	! global  arrays (compact columns)
	real*8 BCvalue(Nb,Ns,2)			! BC value (jx_bar, qx_bar or c_bar)
	real*8 BCn(Nb,2)			! BC outwards normal
	character*1 BCtype(Nb)			! BC type ('R', 'N' or 'D')
	integer ie(Ne,5)			! global connectivity array
	real*8 x(Nn,2)				! global coordinates array
	integer nmat(Nn,0:Nd)			! global nodal materials array
	real*8 V(Ne,2)				! global  arrays
	real*8 C   (Nn,Ns), T   (Nn,Ns)		! global  arrays
	real*8 Cold(Nn,Ns), Told(Nn,Ns) 	! global  arrays
	real*8 phi(Nn), phio(Nn)		! global  arrays
	real*8 vA (NnNd ), vL (NnNd ), vB(NnNd)	! global  arrays (compact values)
	real*8 vY (NnNd ), vZ (NnNd )		! global  arrays (compact values)
	real*8 vQc1(NnNd), vQd1(NnNd), vF1(NnNd)! global  arrays (compact values)
	real*8 vQc2(NnNd), vQd2(NnNd), vF2(NnNd)! global  arrays (compact values)
	real*8 M1(0:Np,Nm)			! Mp(dt) for term p, mat m
	real*8 par(0:Np,2,Nm)			! M(t) parameters
	real*8 In(Nn,Ns,0:Np), Iyn(Nn,0:Np)	! convolution arrays M*C and M*phi
	real*8 Ao(Nn), Vm(Nn,2)			! nodal averaged array
	real*8 gm0(Nn,Np), gm1(Nn,Np), m1s(Nn,Np)		! nodal averaged arrays

	integer N_D, Nr				! ### new parameters ###
	integer order(Nn,0:1)			! ### new parameters ###
	real*8 Rr(Nn,Ns)			! ### new parameters ###
	real*8, allocatable ::  Cr(:,:)		! ### new parameters ###

	integer, allocatable :: ec(:)			! element counter at each node

	integer, allocatable :: rBo(:)			! global  arrays (compact rows)
	integer, allocatable :: cBo(:)			! global  arrays (compact columns)
	real*8, allocatable :: vBo (:)			! global  arrays (compact values)
	integer i, j, k, m, n, p, md, e, i1, i2, s
	real*8 alpha, beta, Ap, Bp, gm, gm0s, gm1s, sx, sy, Lx

!	write(idbg,'(a)') ' --- INIT ---'	! ### TEMPORARY ###
    
! reset T to 0
	T = 0		! use matrix form

! store A in Z
	vZ = vA	! use matrix form
	rZ = rA	! use matrix form
	cZ = cA	! use matrix form
	lastZ = lastA

! average V on all elements interfacing node i

	allocate ( ec(Nn) )		! allocate ec
	ec = 0		! use matrix form
	Vm = 0.d0	! use matrix form
	do e = 1, Ne
	  do i = 1, 4
	    n = ie(e,i)		! node i of element e
	    ec(n) = ec(n) + 1	! sum number of elements at this node
	    do i1 = 1, 2
	      Vm(n,i1) = Vm(n,i1) + V(e,i1)
	    enddo	! i1
	  enddo		! i
	enddo		! e
! average nodal velocity by number of elements at each node
	do n = 1, Nn
	  do i1 = 1, 2
	    Vm(n,i1) = Vm(n,i1) / ec(n)
	  enddo	! i1
	enddo		! n
	deallocate ( ec )		! deallocate ec

! calculate B=P-L and store in B
	do i = 1, Nn
	  do j = 1, Nn
	    sx = 0.
! access rank 2 sparse arrays
	    call ACCESS2(iout, idbg, Nn, NnNd, rL, cL, i, j, lastL, m)
	    call ACCESS2(iout, idbg, Nn, NnNd, rB, cB, i, j, lastB, n)

	    if (m .ne. 0)	then
	      sx = vL(m)		! store L(i,j) in sx
	    endif

	    if (n .ne. 0)	then
	      vB(n) = vB(n) - sx	! store B(i,j)-L(i,j) in vB
	    endif

	  enddo	! j
	enddo	! i

	if(Np .eq. 0)	then
! for ADE
! store A in Y
	  if(Kappa .ne. 0.) then
	    vY = vA	! use matrix form
	    rY = rA	! use matrix form
	    cY = cA	! use matrix form
	    lastY = lastA
	  endif

! calculate alpha = A/dt + B*theta  and store in A
! calculate beta  = A/dt - B*theta1 and store in L
	  do i = 1, Nn

	    if(Kappa .ne. 0.) then
	      phi(i) = C(i,1)*C(i,2)	! initialize phi
	    endif
	    do j = 1 ,Nn
	      sx = 0.
	      sy = 0.
! access rank 2 sparse arrays
	      call ACCESS2(iout, idbg, Nn, NnNd, rA, cA, i, j, lastA, k)
	      call ACCESS2(iout, idbg, Nn, NnNd, rL, cL, i, j, lastL, m)
	      call ACCESS2(iout, idbg, Nn, NnNd, rB, cB, i, j, lastB, n)

	      if (k .ne. 0)	then
	        sx = vA(k)	! store A(i,j) in sx
	      endif

	      if (n .ne. 0)	then
	        sy = vB(n)	! store B(i,j) in sy
	      endif

	      if (k .ne. 0 .or. n .ne. 0)	then	! skip if both A and B are 0
	        alpha = sx/dt + sy*theta
	        beta =  sx/dt - sy*theta1
	      endif

	      if (k .ne. 0)	then
	        vA(k) = alpha
	      endif

	      if (m .ne. 0)	then
	        vL(m) = beta
	      endif
	    enddo	! j
	  enddo		! i
	else

! for EXP
! store -A/tc in Y (ASSUMING Y has the same nonzeros structure as A)
	  if(Kappa .ne. 0.) then
	    rY = rA	! use matrix form
	    cY = cA	! use matrix form
	    lastY = lastA
	  endif

	  Ao  = 0.d0	! use matrix form
	  gm0 = 0.d0	! use matrix form
	  gm1 = 0.d0	! use matrix form
	  m1s = 0.d0	! use matrix form

	  do i = 1, Nn
! average on all materials interfacing node i
	    md = nmat(i,0)	! number of elements at this node
! for M(t)
	    gm0s = 0.
	    gm1s = 0.
	    do p = 0, Np
	      do k = 1, md
	        m = nmat(i,k)
	        Ap = par(p,1,m)
		if(p .eq. 0) then
! temporarily store the sum on k of Ao in Ao
	          Ao(i) = Ao(i) + Ap
		else
	          Bp  = par(p,2,m)
	          gm  = 1.d0 / (Bp*Bp * dt)
	          gm0(i,p) = gm0(i,p) + (Ap - (Bp*dt+1.d0)*M1(p,m) )*gm	! sum{gamma_p^n}
	          gm1(i,p) = gm1(i,p) + (Ap*(Bp*dt-1.d0) + M1(p,m) )*gm	! sum{gamma_p^n+1}
		  m1s(i,p) = m1s(i,p) + M1(p,m) / Ap			! sum{exp(-Bp*dt)}
		endif
	      enddo	! k
	      if(p .eq. 0) then
		Ao(i)  = Ao(i) / md		! avg on k of Ao
	      else
		gm0(i,p) = gm0(i,p) / md	! avg on k of gamma_p^n
		gm1(i,p) = gm1(i,p) / md	! avg on k of gamma_p^n+1
		m1s(i,p) = m1s(i,p) / md	! avg on k of exp(-Bp*dt)
		gm0s = gm0s + gm0(i,p)		! sum on p of gamma_p^n
		gm1s = gm1s + gm1(i,p)		! sum on p of gamma_p^n+1
	      endif

! initialize the convolution array In to Ao*C(0) for p=0 (and 0 otherwise)
	      do s=1, Ns
		if(p .eq. 0) then
		  In(i,s,p) = Ao(i) * C(i,s)
		else
		  In(i,s,p) = 0.
		endif
	      enddo	! s
	    enddo	! p

! for reactive transpost only
	    if(Kappa .ne. 0.) then
	      phi(i) = C(i,1)*C(i,2)	! initialize phi
! initialize the convolution array Iyn to Ao*phi(0) for p=0 (and 0 otherwise)
	      do p = 0, Np
		if(p .eq. 0) then
		  Iyn(i,p) = Ao(i) * phi(i)
		else
		  Iyn(i,p) = 0.
		endif
	      enddo	! p
	    endif

! calculate alpha = A/dt + B* theta * ( sum{gm1} +        Ao ) and store in A
! calculate beta  = A/dt - B*(theta *   sum{gm0} - theta1*Ao ) and store in L
	    do j = 1, Nn
	      sx = 0.
	      sy = 0.
! access rank 2 sparse arrays
	      call ACCESS2(iout, idbg, Nn, NnNd, rA, cA, i, j, lastA, k)
	      call ACCESS2(iout, idbg, Nn, NnNd, rL, cL, i, j, lastL, m)
	      call ACCESS2(iout, idbg, Nn, NnNd, rB, cB, i, j, lastB, n)
	      if (k .ne. 0)	then
	        sx = vA(k)	! store A(i,j) in sx
	      endif

	      if (n .ne. 0)	then
	        sy = vB(n)	! store B(i,j) in sy
	      endif

	      if (k .ne. 0 .or. n .ne. 0)	then	! skip if both A and B are 0

! store -A/tc in Y (ASSUMING Y has the same nonzeros structure as A)
	        if(Kappa .ne. 0.) then
	          vY(n) =- sx/tc
	        endif

	        alpha = sx/dt + sy* theta*(gm1s +        Ao(i))
	        beta =  sx/dt - sy*(theta* gm0s + theta1*Ao(i))
	      endif

	      if (k .ne. 0)	then
	        vA(k) = alpha
	      endif

	      if (m .ne. 0)	then
	        vL(m) = beta
	      endif
	    enddo	! j
	  enddo		! i

	endif

	allocate ( vBo(NnNd), cBo(NnNd), rBo(Nn+1) )

! create a list of the original vs reordered nodes
	call DORDER(iout, idbg, Ne, Nn, Nb, BCe, BCi, BCtype, ie, &
			N_D, order)	! ### new parameters ###

! permute A rows & columns into Bo if Dirichlet BC
	call DPERM (Nn, vA, cA, rA, vBo, cBo, rBo, order(:,1), order(:,1), 1)

	Nr = Nn - N_D		! reduced rows and columns
	allocate( Cr(Nn,Ns) )	! constant part
	Cr = 0.			! initialize Cr

	do n = 1, Nb

! calculate boundary faces unit normals
	  e = BCe(n,3)	! BC element number
	  i = BCi(n)	! BC local element face number
	  if     (i .eq. 1) then
	    i1 = ie(e,1)
	    i2 = ie(e,2)
	  else if(i .eq. 2) then
	    i1 = ie(e,2)
	    i2 = ie(e,3)
	  else if(i .eq. 3) then
	    i1 = ie(e,3)
	    i2 = ie(e,4)
	  else if(i .eq. 4) then
	    i1 = ie(e,4)
	    i2 = ie(e,1)
	  endif
	  sx = x(i2,1)-x(i1,1)		! i1->i2 x component
	  sy = x(i2,2)-x(i1,2)		! i1->i2 y component
	  Lx = sqrt(sx**2 + sy**2)	! Lx length
	  BCn(n,1) = sy/Lx		! unit normal x component
	  BCn(n,2) =-sx/Lx		! unit normal y component
	  BCe(n,1) = i1			! store BC node 1 in BCe
	  BCe(n,2) = i2			! store BC node 2 in BCe

! replace C(i,s) by Cbar if Dirichlet BC
	  if(BCtype(n) .eq. 'D') then
	    do p = 1, 2
	      i = BCe(n,p)		! BC global node p number
	      do s = 1, Ns
	        Cr(i,s) = BCvalue(n,s,p)
	        C (i,s) = BCvalue(n,s,p)
	      enddo	! s
	    enddo	! p
	  endif
	enddo		! n

	do s = 1, Ns
! permute Cr vector (in-place)
	  call DVPERM (Nn, Cr(:,s), order(:,1)) 

! calculate {Ra} = [Baa]{0} + [Bab]{Cb}
	  call AMUX(Nn, Cr(:,s), Rr(:,s), vBo, cBo, rBo)
! make {Rb} = 0
	  do i = Nr+1, Nn
	    Rr(i,s) = 0.
	  enddo	! i
	enddo	! s

! extract submatrix Baa into A
	call SUBMAT (Nn ,1, 1, Nr, 1, Nr, vBo, cBo, rBo, Nr, Nr, vA, cA, rA)
	lastA = rA(Nr+1) - rA(1)	! update lastA
	deallocate ( Cr )		! deallocate Cr
	deallocate ( vBo, cBo, rBo )	! deallocate Bo

! reset C and T of the former time step, Cold and Told, to C and T, respectively
	Cold = C	! use matrix form
	Told = T	! use matrix form
	if(Np.ne.0 .and. Kappa.ne.0.) then
! for reactive EXP only
! reset phi of the former time step, phio, to phi
	  phio= phi	! use matrix form
	endif
	
!	F = Qc + Qd			! flux

! copy Qd to F
	rF1 = rQd1
	rF2 = rQd2
	cF1 = cQd1
	cF2 = cQd2
	vF1 = vQd1
	vF2 = vQd2
	lastF1 = lastQd1
	lastF2 = lastQd2

	do j = 1, Nn
	  do k = 1, Nn
	    sx = 0.
! access rank 2 sparse arrays
	    call ACCESS2(iout, idbg, Nn, NnNd, rQc1, cQc1, j, k, lastQc1, m)
	    call ACCESS2(iout, idbg, Nn, NnNd, rF1 , cF1 , j, k, lastF1 , n)

	    if (m .ne. 0)	then
	      sx = vQc1(m)		! store Qc1(j,k) in sx
	    endif

	    if (n .ne. 0)	then
	      vF1(n) = vF1(n) + sx	! store Qd1(j,k)+Qc1(j,k) in F1
	    endif
	    sy = 0.
! access rank 2 sparse arrays
	    call ACCESS2(iout, idbg, Nn, NnNd, rQc2, cQc2, j, k, lastQc2, m)
	    call ACCESS2(iout, idbg, Nn, NnNd, rF2 , cF2 , j, k, lastF2 , n)

	    if (m .ne. 0)	then
	      sy = vQc2(m)		! store Qc2(j,k) in sy
	    endif

	    if (n .ne. 0)	then
	      vF2(n) = vF2(n) + sy	! store Qd2(j,k)+Qc2(j,k) in F2
	    endif

	  enddo	! k
	enddo	! j

	return
	end

